package cn.smarthse.rho.modules.sys.provider.risk;


import cn.smarthse.rho.modules.sys.model.r.param.AddRiskForCommonParam;
import cn.smarthse.rho.modules.sys.model.r.param.RiskMangerGenParam;

import java.util.List;

/**
 * 暴露接口 - 风险
 * @author chuhy
 * @date 2024/8/2 15:00
 */
public interface IRiskProvider {

    /**
     * 通用接口 - 生成风险
     * 生成规则：
     * 1.basic每个企业每年每个类型只有一条记录
     * 2.source和basic是一对多关系，一条basic会有多条source记录
     *
     * @author chuhy
     * @date 2024/7/29 15:21
     */
    void genRiskOfCommon(List<AddRiskForCommonParam> paramList);

    /**
     * 通用接口 - 化解风险
     *
     * @author chuhy
     * @date 2024/8/26 15:56
     */
    void resolveRiskOfCommon(List<Long> sourceIdList);

    /**
     * 变更source风险预警状态
     * @param param
     * @author chuhy
     * @date 2024/9/5 14:47
     */
    void searchAndChangeSourceRiskWarningStatus(RiskMangerGenParam param);

    /**
     * 变更basic风险预警状态
     * @param param
     * @author chuhy
     * @date 2024/9/10 16:14
     */
    void searchAndChangeBasicRiskWarningStatus(RiskMangerGenParam param);
}
