package cn.smarthse.rho.modules.sys.provider.company;


import cn.smarthse.core.framework.model.LayuiGridData;
import cn.smarthse.rho.modules.sys.entity.b.BPost;
import cn.smarthse.rho.modules.sys.model.b.param.BPostEditParam;
import cn.smarthse.rho.modules.sys.model.b.vo.BPostVo;
import cn.smarthse.rho.modules.sys.model.c.param.PostInfoParam;
import cn.smarthse.rho.modules.sys.model.c.param.PostQueryParam;

public interface IPostProvider {
    /**
     * 编辑
     * @Author ChenLiang
     * @Date 13:53 2024/6/20
     * @param param
     * @return void
     */
    void editInfo(BPostEditParam param);

    /**
     * 删除信息
     * @Author ChenLiang
     * @Date 10:23 2024/6/21
     * @param param
     * @return void
     */
    void removeInfo(BPostEditParam param);

    /**
     * 添加
     * @Author ChenLiang
     * @Date 13:53 2024/6/20
     * @param param
     * @return void
     */
    void addInfo(BPostEditParam param);

    /**
     * 员工岗位
     * @Author ChenLiang
     * @Date 16:07 2024/6/20
     * @param param
     * @return LayuiGridData<BPostVo>
     */
    LayuiGridData<BPostVo> getPage(PostQueryParam param);

    /**
     * 获取岗位信息
     * @Author ChenLiang
     * @Date 16:20 2024/6/20
     * @param param
     * @return BPostVo
     */
    BPostVo getPostInfo(PostInfoParam param);
    /**
     * 获取岗位信息
     * @Author ChenLiang
     * @Date 8:34 2024/6/27
     * @param postId 岗位id
     * @return BPostVo
     */
    BPostVo getPostInfo(Long postId);

    BPost getPostInfoForImporting(Long id, String postName);

}
