package cn.smarthse.rho.modules.sys.provider.c;


import cn.smarthse.core.framework.model.LayuiGridData;
import cn.smarthse.rho.modules.sys.model.b.vo.CStaffInfoRangeVo;
import cn.smarthse.rho.modules.sys.model.c.param.*;
import cn.smarthse.rho.modules.sys.model.c.vo.CertStaffChooseListVo;
import cn.smarthse.rho.modules.sys.model.c.vo.StaffChangeLogVo;
import cn.smarthse.rho.modules.sys.model.c.vo.StaffSelectInfo;


public interface IStaffProvider {

    /**
     * 人员信息修改日志
     * @Author ChenLiang
     * @Date 13:38 2024/8/26
     * @param param
     * @return LayuiGridData<StaffChangeLogVo>
     */
    LayuiGridData<StaffChangeLogVo> getStaffChangeLog(StaffChangeLogParam param);
    LayuiGridData<CertStaffChooseListVo> getCertStaffChooseList(CertStaffChooseListParam param);


    /**
     * 人员信息查看范围（公司）
     * @Author ChenLiang
     * @Date 9:20 2024/10/22
     * @param param
     * @return CStaffInfoRangeVo
     */
    CStaffInfoRangeVo getStaffInfoRangeForCompany(CStaffInfoRangeParam param);

    /**
     * 人员信息查看范围（监管）
     * @Author ChenLiang
     * @Date 9:20 2024/10/22
     * @param param
     * @return CStaffInfoRangeVo
     */
    CStaffInfoRangeVo getStaffInfoRangeForAdmin(CStaffInfoRangeParam param);


    /**
     * 用户选择专用，关键信息加上脱敏
     * @param idCard
     * @return
     */
    StaffSelectInfo getSelectInfoForAdding(StaffSelectInfoParam param);

    void addManager(CStaffBaseInfoEditParam param);

    void addStaffFullInfo(CStaffBaseInfoEditParam param);

    void editStaffFullInfo(CStaffBaseInfoEditParam param);
}
