package cn.smarthse.rho.modules.sys.model.wanda.sync.vo;

import lombok.Data;
import lombok.EqualsAndHashCode;

import java.time.LocalDateTime;
import java.util.Date;

@Data
@EqualsAndHashCode(callSuper = false)
public class WandaZwyPlaceVo {

    // 场所场所id (外部数据库)
    private String zwyEngineRoomId;

    // 场所场所id (放射卫生在线数据库id, 场所来源是放射卫生非必填)
    private String rhoEngineRoomId;

    // 放射诊疗机构id (外部数据库)
    private String zwyHospitalId;

    // 放射诊疗机构id (放射卫生在线)
    private String rhoHospitalId;

    // cid(由zwy_hospital_id字段连b_company查出)
    private Long cid;

    // 设备id (外部数据库)
    private String zwyDeviceId;

    // 设备id (放射卫生在线)
    private String rhoDeviceId;

    // 场所名称
    private String name;

    // 场所编号
    private String roomCode;

    // 是否为车载场所 (0-否；1-是)
    private String isOnboard;

    // 工作场所级别 (1-甲级；2-乙级；3-丙级)
    private String levels;

    // 数据来源 (1-放射卫生在线，2-外部数据库)
    private String dataSource;

    // 操作类型；1-新增；2-更新；3-删除
    private String optType;

    // 更新或删除的数据id，更新删除时必填
    private String oldSourceId;

    // 更新或删除原因，更新删除时必填
    private String optReason;

    // 万达仓数据创建时间
    private LocalDateTime loadTime;
}

