package cn.smarthse.rho.modules.sys.model.wanda.sync.vo;

import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.util.Date;

/**
 * 万达仓：放射卫生-场所检测数据主表
 *
 * @author  wuxq
 * @since   2024/12/11
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class WandaFswsPlaceCheckVo implements Serializable {

    private static final long serialVersionUID = 1L;

    private Long   id;
    private String sourceId;                // 唯一标识（外部数据库原始数据id）
    private String orgName;                 // 检测机构名称
    private String orgCode;                 // 检测机构信用代码
    private String zwyHospitalId;           // 放射诊疗机构id（外部数据库）
    private String rhoHospitalId;           // 放射诊疗机构id（放射卫生在线）
    private String hospitalName;            // 放射诊疗机构名称
    private String hospitalCreditCode;      // 放射诊疗机构统一信用代码（无则传18个0）
    private String checkType;               // 检测类型（1、验收（控评）检测；2、状态（年度）检测）
    private String checkTime;               // 检测时间（yyyy-MM-dd）
    private String reportNo;                // 报告编号（多个场所一份报告时必填）
    private String reportName;              // 检测报告名称（多个场所一份报告时必填）
    private String reportUrl;               // 报告下载地址（多个场所一份报告）
    private String checkNum;                // 检测场所数
    private String failNum;                 // 不合格场所数
    private String isInfulenceReport;       // 是否影响已推送报告（1、是；2否）
    private String dealType;                // 处理方式（1、替换内容；2、合并）
    private String optType;                 // 操作类型；1-新增；2-更新；3-删除
    private String oldSourceId;             // 更新或删除的数据id，更新删除时必填
    private String optReason;               // 更新或删除原因，更新删除时必填
    private Date   loadTime;                  // 万达仓数据创建时间
    private String uniqueid;                // id_  + load_time

    private Integer syncErrType;            // 同步错误类型（0-去重忽略；1-正常同步；2-数据异常）
    private Integer dataErrType;             // 数据异常类型（待确定）
    private String dataErrDesc;             // 数据异常类型描述（待确定）
}
