package cn.smarthse.rho.modules.sys.model.wanda.sync.vo;

import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.util.Date;

/**
 * 万达仓：放射卫生-设备检测数据子表
 *
 * @author  wuxq
 * @since   2024/12/11
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class WandaFswsDeviceCheckDataVo implements Serializable {

    private static final long serialVersionUID = 1L;

    private Long id;
    private String sourceId;                // 唯一标识（外部数据库原始数据id）
    private String checkId;                 // 设备性能检测主表id
    private String hospitalName;            // 所在放射诊疗机构名称
    private String hospitalCreditCode;      // 放射诊疗机构统一信用代码
    private String zwyHospitalId;           // 放射诊疗机构id（外部数据库）
    private String rhoHospitalId;           // 放射诊疗机构id（放射卫生在线）
    private String zwyDeviceId;             // 设备id（外部数据库数据库ID）
    private String rhoDeviceId;             // 设备id（放射卫生在线数据库ID）
    private String deviceName;              // 设备名称
    private String deviceModel;             // 型号
    private String deviceNo;                // 出厂编号
    private String ifSealedSource;          // 是否含密封源装置（0-否；1-是）
    private String sealedSourceId;          // if_sealed_source=1时必填，外部数据库密封性放射性同位素id
    private String deviceMoveType;          // 是否可移动设备（0-否；1-是）
    private String bedsideType;             // 是否床边设备（0-否；1-是）
    private String vehicleType;             // 是否车载设备（0-否；1-是）
    private String zwyEngineRoomIds;        // 场所id（外部数据库场所id，除可移动床边设备外必填，可移动设备可对应多个场所，多个以英文逗号分隔）
    private String result;                  // 检测结果（1、合格；2、不合格）
    private String checkReportName;         // 检测报告名称（单个设备一份报告）
    private String checkReportNo;           // 检测报告编号（单个设备一份报告）
    private String checkReportUrl;          // 检测报告下载地址（单个设备一份报告）
    private String isInfulenceReport;       // 是否影响已推送报告（1、是；2否）
    private String dealType;                // 处理方式（1、替换内容；2、合并）
    private String optType;                 // 操作类型；1-新增；2-更新；3-删除
    private String oldSourceId;             // 更新或删除的数据id，更新删除时必填
    private String optReason;               // 更新或删除原因，更新删除时必填
    private Date loadTime;                  // 万达仓数据创建时间
    private String uniqueid;                // id_  + load_time

    private Integer syncErrType;            // 同步错误类型（0-去重忽略；1-正常同步；2-数据异常）
    private Integer dataErrType;            // 数据异常类型（待确定）
    private String dataErrDesc;             // 数据异常类型描述（待确定）
}
