package cn.smarthse.rho.modules.sys.model.third.param;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 三方接口 - 设备 - 非密封放射性核素
 */
@Data
public class ThirdSourceNonSealedDto implements Serializable{
	private static final long serialVersionUID = -2288656407681199015L;
	
	/**
	 * 物理状态（1-固态；2-液态；3-气态）
	 */
	@ApiModelProperty(value = "物理状态（1-固态；2-液态；3-气态）",required = true)
	private Integer physicalState;
	
	/**
	 * 最大等效日操作量(前，保留两位小数)
	 */
	@ApiModelProperty(value = "最大等效日操作量(前，保留两位小数)",required = true)
	private BigDecimal data1;
	
	/**
	 * 最大等效日操作量(后)
	 */
	@ApiModelProperty(value = "最大等效日操作量(后)",required = true)
	private Integer data2;
	
	/**
	 * 最大等效年操作量(前，保留两位小数)
	 */
	@ApiModelProperty(value = "最大等效年操作量(前，保留两位小数)",required = true)
	private BigDecimal data3;
	
	/**
	 * 最大等效年操作量(后)
	 */
	@ApiModelProperty(value = "最大等效年操作量(后)",required = true)
	private Integer data4;
	
	/**
	 * 负责人
	 */
	@ApiModelProperty(value = "负责人",required = true)
	private String personInCharge;

}
