package cn.smarthse.rho.modules.sys.model.third.param;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.Valid;
import javax.validation.constraints.NotEmpty;
import java.io.Serializable;

/**
 * 三方接口 - 新增机房场所
 */
@Data
public class ThirdMachineRoomDto implements Serializable{
	private static final long serialVersionUID = -643907071184327315L;

	@ApiModelProperty(value = "机房id")
	private Long id;

	/**
	 * 医院唯一码
	 */
	@NotEmpty(message = "医院唯一码不能为空")
	@ApiModelProperty(value = "医院唯一码")
	private String uniqueCode;

	/**
	 * 机房名称
	 */
	@ApiModelProperty(value = "机房名称")
	private String name;

	/**
	 * 是否为车载机房（0-否；1-是）
	 */
	@ApiModelProperty(value = "是否为车载机房（0-否；1-是）")
	private Integer isOnboard;

	/**
	 * 工作场所级别(1-甲级；2-乙级；3-丙级)
	 */
	@ApiModelProperty(value = "工作场所级别(1-甲级；2-乙级；3-丙级)")
	private Integer level;

}
