package cn.smarthse.rho.modules.sys.model.third.param;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;


/**
 * 三方接口 - 设备 - 射线装置
 */
@Data
public class ThirdDeviceRayDto implements Serializable{
	private static final long serialVersionUID = -8860356858714162063L;


	/**
	 * 设备移动类型(1-固定设备；2-移动设备；3-车载设备)
	 */
	@ApiModelProperty(value = "设备移动类型(1-固定设备；2-移动设备；3-车载设备)",required = true)
	private Integer mobilityType;

	/**
	 * 是否为床边机(0-否；1-是)（mobility_type为2时才有值）
	 */
	@ApiModelProperty(value = "是否为床边机(0-否；1-是)（mobility_type为2时才有值）")
	private Integer isBedside;

	/**
	 * 放射诊疗类别(英文逗号分隔)(EdeviceDiagnosisTypeEnum)
	 */
	@ApiModelProperty(value = "放射诊疗类别(英文逗号分隔)(EdeviceDiagnosisTypeEnum)",required = true)
	private String diagnosisType;

	/**
	 * 型号
	 */
	@ApiModelProperty(value = "型号",required = true)
	private String model;

	/**
	 * 主要参数
	 */
	@ApiModelProperty(value = "主要参数",required = true)
	private String parameters;

	/**
	 * 球管个数
	 */
	@ApiModelProperty(value = "球管个数",required = true)
	private Integer bulbNum;

	/**
	 * 放射检查类型（EdeviceRayCheckTypeEnum）
	 */
	@ApiModelProperty(value = "放射检查类型（EdeviceRayCheckTypeEnum）",required = true)
	private Integer checkType;

	/**
	 * 出厂日期
	 */
	@ApiModelProperty(value = "出厂日期",required = true)
	private Date productionDate;

	/**
	 * 安装单位
	 */
	@ApiModelProperty(value = "安装单位",required = true)
	private String installationUnit;

	/**
	 * 负责人
	 */
	@ApiModelProperty(value = "负责人",required = true)
	private String personInCharge;

}
