package cn.smarthse.rho.modules.sys.model.sys.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * 监管端：系统模块-单位用户详情
 *
 * @author liaoly(廖凌云) [1302013247@qq.com]
 * @date 2024/6/4 16:42
 */
public @Data class SysUserCompanyOneForSupVo implements Serializable {

    private static final long serialVersionUID = 1L;

    private Long id;

    @ApiModelProperty(value = "账号")
    private String username;

    private Long cid;

    @ApiModelProperty("所在医院名称")
    private String hospitalName;

    @ApiModelProperty(value = "院区名")
    private String branchName;

    @ApiModelProperty(value = "统一社会信用代码")
    private String creditCode;

    @ApiModelProperty("全国统一码")
    private String medicalNucode;

    @ApiModelProperty(value = "行政区划id")
    private Long areaId;
    @ApiModelProperty(value = "行政区划")
    private String areaName;
    private SysAreaVo sysArea;

    @ApiModelProperty(value = "直属类型：0非直属， 1省直属，2市属")
    private Integer belongType;

    @ApiModelProperty(value = "监督单位id")
    private Long supervisionUnit;

    @ApiModelProperty(value = "监督单位")
    private String supervisionUnitStr;

    @ApiModelProperty("是否是测试")
    private Integer isTest;

    /**
     * 营业状态
     */
    private Integer businessStatus;

    /**
     * 是否禁用(1-禁用，0-启用)
     */
    private Integer isForbidden;

    /**
     * 账号启用禁用时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime forbiddenUpdateTime;

}
