package cn.smarthse.rho.modules.sys.model.sys.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * 单位用户列表dto
 *
 * @author liaoly(廖凌云) [1302013247@qq.com]
 * @date 2024/5/15 13:18
 */
public @Data class SysUserCompanyListForSupVo implements Serializable {

    private static final long serialVersionUID = 1L;

    private Long id;

    @ApiModelProperty(value = "账号")
    private String username;

    private Long cid;

    @ApiModelProperty("所在医院名称")
    private String hospitalName;

    @ApiModelProperty(value = "院区名")
    private String branchName;

    @ApiModelProperty(value = "统一社会信用代码")
    private String creditCode;

    @ApiModelProperty(value = "行政区划id")
    private Long areaId;

    @ApiModelProperty(value = "行政区划")
    private String areaName;

    @ApiModelProperty(value = "是否禁用(1-禁用，0-启用)")
    private Integer isForbidden;

    @ApiModelProperty(value = "营业状态")
    private Integer businessStatus;

    /**
     * 入库时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd")
    private LocalDateTime entryTime;

}
