package cn.smarthse.rho.modules.sys.model.sys.vo;

import cn.smarthse.rho.modules.sys.model.sys.param.SysRoleDto;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;

/**
 * 单位用户列表dto
 *
 * @author liaoly(廖凌云) [1302013247@qq.com]
 * @date 2024/5/15 13:18
 */
public @Data class SysUserCompanyListForComVo implements Serializable {

    private static final long serialVersionUID = 1L;

    private Long id;

    @ApiModelProperty(value = "账号")
    private String username;

    @ApiModelProperty(value = "角色(id与name)")
    private List<SysRoleDto> roleList;

    @ApiModelProperty(value = "是否禁用")
    private Integer isForbidden;

    @JsonFormat(pattern = "yyyy-MM-dd")
    @ApiModelProperty(value = "更新时间")
    private LocalDateTime updateDate;

}
