package cn.smarthse.rho.modules.sys.model.sys.vo;

import cn.smarthse.core.framework.model.PageParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 系统模块：院区管理列表
 *
 * @author liaoly(廖凌云) [1302013247@qq.com]
 * @date 2024/5/23 16:34
 */
@EqualsAndHashCode(callSuper = true)
public @Data class SysCompanyListVo extends PageParam {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("全国统一码")
    private String medicalNucode;

    @ApiModelProperty("所在医院id")
    private Long hospitalId;
    @ApiModelProperty("所在医院名称")
    private String hospitalName;

    @ApiModelProperty("院区id")
    private Long branchCid;
    @ApiModelProperty("院区名称")
    private String branchName;

    @ApiModelProperty("机房数")
    private Integer machineRoomCount;

    @ApiModelProperty("院区状态（1-开启；0-关闭）")
    private Integer state;

    @ApiModelProperty("是否是主院区（1-是；0-否）")
    private Integer isMain;
}
