package cn.smarthse.rho.modules.sys.model.sys.vo;

import cn.smarthse.rho.modules.sys.enums.sys.SysBusinessOperateLogTypeEnum;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDate;

/**
 * @Author: czq
 * @Creat: 2024/11/19 8:15
 */
@Data
public class SysBusinessOperateLogVo implements Serializable {

    private static final long serialVersionUID = 1L;


    @ApiModelProperty("操作人")
    private String operator;
    @ApiModelProperty("创建时间")
    private LocalDate createDate;
    @ApiModelProperty("操作类型，1提交，2退回")
    private Integer type;
    @ApiModelProperty("操作类型名称，1提交，2退回")
    private String typeName;
    @ApiModelProperty("操作原因")
    private String reason;
    @ApiModelProperty("佐证材料文件")
    private SysFileVo file;

    public String getTypeName() {
        if (type == null) {
            return "";
        }
        if (type == 1) {
            return SysBusinessOperateLogTypeEnum.SUBMIT.getName();
        }
        if (type == 2) {
            return SysBusinessOperateLogTypeEnum.BACK.getName();
        }
        return "";
    }
}
