package cn.smarthse.rho.modules.sys.model.sys.param;

import cn.smarthse.core.framework.model.UserEditParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotEmpty;

/**
 * 表头设置：保存
 *
 * @author liaoly(廖凌云) [1302013247@qq.com]
 * @date 2024/5/15 15:51
 */
@EqualsAndHashCode(callSuper = true)
public @Data class SysSettingTableEditParam extends UserEditParam {

    private static final long serialVersionUID = 1L;
    /**
     * 表code（用接口地址，eg：/company/getListData）
     */
    @ApiModelProperty(value = "表code（用接口地址，eg：/company/getListData）")
    @NotEmpty
    private String tableCode;
    /**
     * 表name（eg：医用放射单位管理档案）
     */
    @ApiModelProperty(value = "表name（eg：医用放射单位管理档案）")
    @NotEmpty
    private String tableName;
    /**
     * 参数配置（eg：姓名|name,性别|sex,账号|username,手机号|mobile）
     */
    @ApiModelProperty(value = "参数配置（eg：姓名|name,性别|sex,账号|username,手机号|mobile）")
//    @NotEmpty
    private String data;
}
