package cn.smarthse.rho.modules.sys.model.sys.param;

import cn.smarthse.core.framework.model.BaseEntity;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 操作日志
 *
 * @author liaoly(廖凌云) [1302013247@qq.com]
 * @date 2022/3/7 16:20
 */
@EqualsAndHashCode(callSuper = true)
@Data
@Accessors(chain = true)
public class SysLogAddParam extends BaseEntity {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("ID")
    private Long id;

    @ApiModelProperty("账号id")
    private Long userId;

    @ApiModelProperty("操作账号(冗余)")
    private String username;

    @ApiModelProperty("用户姓名(冗余)")
    private String fullname;

    private Long provinceId;
    private Long cityId;
    private Long areaId;
    private Long streetId;
    @ApiModelProperty("行政区划")
    private Long detailAreaId;

    @ApiModelProperty("cid")
    private Long cid;

    @ApiModelProperty("日志标题")
    private String title;

    @ApiModelProperty("来源（LogResourceEnum）")
    private Integer resource;

    @ApiModelProperty("模块（LogModuleTypeEnum）")
    private Integer moduleType;

    @ApiModelProperty("类型（LogTypeEnum）")
    private Integer type;

    @ApiModelProperty("请求IP地址")
    private String remoteIp;

    @ApiModelProperty("用户代理信息")
    private String userAgent;

    @ApiModelProperty("请求URI")
    private String requestUri;

    @ApiModelProperty("操作方式、post/get/push等resetful")
    private String requestMethod;

    @ApiModelProperty("操作提交的数据内容(json)或者异常信息")
    private String params;
}
