package cn.smarthse.rho.modules.sys.model.sys.param;

import cn.smarthse.core.framework.model.UserEditParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotNull;

/**
 * 医院端：系统管理-用户管理 禁用、启用参数
 *
 * @author liaoly(廖凌云) [1302013247@qq.com]
 * @date 2022/3/10 17:14
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class SysCompanyUserStatueEditForComParam extends UserEditParam {

    private static final long serialVersionUID = 3055226672737277076L;

    @ApiModelProperty(value = "userId", required = true)
    @NotNull
    private Long userId;

    @ApiModelProperty(value = "禁用/停用（1-禁用；0-启用）", required = true)
    @NotNull
    private Integer isForbidden;
}
