package cn.smarthse.rho.modules.sys.model.sys.param;

import cn.smarthse.core.framework.model.UserEditParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotNull;

/**
 * 监管端：系统管理-用户管理 编辑
 *
 * @author liaoly(廖凌云) [1302013247@qq.com]
 * @date 2024/6/3 10:17
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class SysCompanyUserEditForSupParam extends UserEditParam {

    private static final long serialVersionUID = 1L;

    private Long id;

    /**
     * 账号名称
     */
    private String username;

    @ApiModelProperty(value = "院区名")
    private String branchName;

    @ApiModelProperty(value = "统一社会信用代码")
    private String creditCode;

    @NotNull(message = "cid不能为空")
    @ApiModelProperty(value = "cid", required = true)
    private Long cid;

    @NotNull(message = "行政区划不能为空")
    @ApiModelProperty(value = "行政区划id", required = true)
    private Long areaId;

    @NotNull(message = "直属类型不能为空")
    @ApiModelProperty(value = "直属类型：0非直属， 1省直属，2市属", required = true)
    private Integer belongType;

    //@NotNull(message = "是否是测试不能为空")
    @ApiModelProperty(value = "是否是测试", required = true)
    private Integer isTest;

}
