package cn.smarthse.rho.modules.sys.model.sys.param;

import cn.smarthse.core.framework.model.UserEditParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import java.util.List;

/**
 * 医院端：系统管理-用户管理 添加
 *
 * @author liaoly(廖凌云) [1302013247@qq.com]
 * @date 2024/6/3 10:17
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class SysCompanyUserAddForComParam extends UserEditParam {

    private static final long serialVersionUID = 1L;

    @NotBlank(message = "账号不能为空")
    @ApiModelProperty(value = "账号")
    private String username;

    @ApiModelProperty(value = "昵称")
    private String nickname;

    @NotEmpty(message = "角色不能为空")
    @ApiModelProperty(value = "角色(id与name)")
    private List<SysRoleDto> roleList;

    @ApiModelProperty(value = "手机号")
    private String tel;

    @ApiModelProperty(value = "职务")
    private String post;

    @ApiModelProperty(value = "部门")
    private String department;

}
