package cn.smarthse.rho.modules.sys.model.sys.param;

import cn.smarthse.core.framework.model.UserEditParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * 监管端：系统管理-院区管理 编辑
 *
 * @Author liaoly(廖凌云) [1302013247@qq.com]
 * @Date 2024/6/4 10:06
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class SysCompanyEditParam extends UserEditParam {

    private static final long serialVersionUID = 1L;

    /**
     * 全国统一码
     */
    private String medicalNucode;

    @NotBlank(message = "所在医院名称不能为空")
    @ApiModelProperty("所在医院名称")
    private String hospitalName;

    @NotNull(message = "院区id不能为空")
    @ApiModelProperty("院区id")
    private Long branchCid;
    @NotBlank(message = "院区名称不能为空")
    @ApiModelProperty("院区名称")
    private String branchName;

}
