package cn.smarthse.rho.modules.sys.model.r.vo;

import cn.smarthse.rho.modules.sys.enums.risk.KeyFactoAuditStatusEnum;
import cn.smarthse.rho.modules.sys.enums.risk.RiskTypeEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDate;


/**
 * 关键因素画像审核
 *
 * @author <开发者>
 * @since 2024-08-16 09:27
 */
@ApiModel(value = "关键因素画像审核列表", description = "关键因素画像审核VO")
@Data
public class RKeyFactorAuditVo implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "id")
    private Long id;

    @ApiModelProperty(value = "医院id")
    private Long cid;

    @ApiModelProperty(value = "医院名称")
    private String companyName;

    @ApiModelProperty(value = "医院地址")
    private String companyAddress;

    @ApiModelProperty(value = "工作地址")
    private String workFullAddress;

    @ApiModelProperty(value = "项目名称（三同时）")
    private String projectName;

    @ApiModelProperty(value = "业务类型")
    private Integer type;
    @ApiModelProperty(value = "业务类型")
    private String typeStr;

    @ApiModelProperty(value = "状态")
    private Integer status;
    @ApiModelProperty(value = "状态")
    private String statusStr;

    @ApiModelProperty(value = "业务id")
    private Long businessId;

    @ApiModelProperty(value = "提交时间")
    private LocalDate createDate;


    public String getTypeStr() {
        return RiskTypeEnum.getName(type);
    }

    public String getStatusStr() {
        return KeyFactoAuditStatusEnum.getName(status);
    }
}
