package cn.smarthse.rho.modules.sys.model.r.vo;

import cn.smarthse.rho.modules.sys.enums.risk.RiskTypeEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;


/**
 * 关键因素画像审核
 *
 * @author <开发者>
 * @since 2024-08-16 09:27
 */
@ApiModel(value = "待审核画像审核统计", description = "待审核画像审核统计VO")
@Data
public class RKeyFactorAuditStatisticsVo implements Serializable {

    private static final long serialVersionUID = 1L;

    private Integer type;
    @ApiModelProperty(value = "画像类型")
    private String typeStr;

    @ApiModelProperty(value = "待审核画像数")
    private Integer unAuditNum;

    public String getTypeStr() {
        return RiskTypeEnum.getName(type);
    }

}
