package cn.smarthse.rho.modules.sys.model.r.vo;

import cn.smarthse.rho.modules.sys.entity.b.BCompany;
import cn.smarthse.rho.modules.sys.enums.risk.KeyFactoAuditStatusEnum;
import cn.smarthse.rho.modules.sys.enums.risk.RiskTypeEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;


/**
 * 关键因素画像审核
 *
 * @author <开发者>
 * @since 2024-08-16 09:27
 */
@ApiModel(value = "关键因素画像审核详情", description = "关键因素画像审核详情VO")
@Data
public class RKeyFactorAuditDetailVo implements Serializable {

    private static final long serialVersionUID = 1L;

    private Long id;

    private Integer type;
    @ApiModelProperty(value = "画像类型")
    private String typeStr;

    @ApiModelProperty(value = "审核状态")
    private Integer status;
    @ApiModelProperty(value = "审核状态")
    private String statusStr;

    @ApiModelProperty(value = "提交时间")
    private Date submitDate;

    @ApiModelProperty(value = "医院信息")
    private BCompany company;

    @ApiModelProperty(value = "业务数据体")
    private Object businessData;

    @ApiModelProperty("未审核画像统计")
    private List<RKeyFactorAuditStatisticsVo> auditStatisticsVos;

    public String getTypeStr() {
        return RiskTypeEnum.getName(type);
    }

    public String getStatusStr() {
        return KeyFactoAuditStatusEnum.getName(status);
    }
}
