package cn.smarthse.rho.modules.sys.model.r.param;

import cn.smarthse.rho.modules.sys.enums.staff.PostStatusEnum;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.List;

/**
 * <p>
 * 风险维护参数
 * </p>
 *
 * @author chenliang
 * @since 2024-04-10
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class RiskMangerGenParam implements Serializable{
    private static final long serialVersionUID = 1L;

    @ApiModelProperty("年份")
    private Integer year;

    @ApiModelProperty("行政区划id（区级）")
    private Long thirdLevelAreaId;

    @ApiModelProperty("有效时间间隔(年)")
    private Integer effectiveYear = 2;

    @ApiModelProperty("有效时间间隔(月)")
    private Integer doseEffectiveMonth = 3;

    @ApiModelProperty("医院id")
    private List<Long> cidList;

    @ApiModelProperty("人员基础信息id")
    private List<Long> staffBaseInfoId;

    @ApiModelProperty("岗位状态（在岗 1）")
    private Integer postStatus = PostStatusEnum.NON_POST.getValue();


}
