package cn.smarthse.rho.modules.sys.model.r.param;

import io.swagger.annotations.ApiModel;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.time.LocalDate;

/**
 * 生成风险通用接口 - 生成风险参数
 * @author chuhy
 * @date 2024/7/29 16:23
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value="生成风险参数", description="生成风险通用接口 - 生成风险参数")
public class AddRiskForCommonParam implements Serializable {
    private static final long serialVersionUID = -268034005078061272L;

    /**
     * 企业ID
     */
    private Long cid;

    /**
     * 企业name
     */
    private String companyName;

    /**
     * 机构id
     */
    private Long thirdOrgId;

    /**
     * 业务id，在风险由画像数据产生时，需要传入。
     * 不同风险类型存入的业务数据id如下：
     * 1.性能检测风险-画像中的检测id（d_device_check.id）。
     * 2.场所检测风险-画像中的检测id（d_location_check.id）。
     * 3.体检风险-画像中的体检id（c_health_check.id）。
     * 4.个人剂量监测风险-画像中的监测id（c_dose.id）。
     * 5.培训风险-画像中的培训证书id（c_training_cert.id）。
     * 6.三同时风险-画像中的三同时id（f_project.id）。
     * 7.许可管理风险-画像中许可校验的id（b_cert_change_log.id）
     */
    private Long businessId;

    /**
     * 细分业务id。
     * 不同风险类型存入的业务数据id如下：
     * 1.性能检测风险-设备id。
     * 2.场所检测风险-场所id。
     * 3.体检风险-人员id。
     * 4.个人剂量监测风险-人员id。
     * 5.培训风险-人员id。
     * 6.三同时风险-设备id。
     * 7.许可管理风险-许可证id。
     */
    private Long subBusinessId;

    /**
     * 业务对应的数据名称（人员名称/设备名称）
     */
    private String subBusinessName;

    /**
     * 风险名称
     */
    private String name;

    /**
     * 风险来源（RiskSourceEnum）
     */
    private Integer source;

    /**
     * 风险类型 （RiskTypeEnum）
     */
    private Integer type;

    /**
     * 发现人name
     */
    private String finderName;

    /**
     * 描述
     */
    private String description;

    /**
     * 附件
     */
    private String files;

    /**
     * 参照起始时间
     */
    private LocalDate startTime;

    /**
     * 参照时间：一般指过期时间
     */
    private LocalDate expireTime;

    /**
     * 整改期限
     */
    private LocalDate requireFinishTime;

    /**
     * 是否由数据产生的风险（0-否；1-是）
     */
    private Integer isGenerateByData;

}
