package cn.smarthse.rho.modules.sys.model.m.vo;

import cn.smarthse.rho.modules.sys.enums.company.EdeviceLicenseStatusEnum;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.util.StringUtils;

import java.io.Serializable;
import java.util.Date;

/**
 * @author  wuxq
 * @since    2024/11/19
 */
public @Data class OnlineMonitoringProtectDeviceModel implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("ID")
    private Long id;

    @ApiModelProperty("医院ID")
    private Long cid;

    @ApiModelProperty("安装医院")
    private String hospitalName;

    @ApiModelProperty("所在院区")
    private String name;

    @ApiModelProperty("所在行政区划")
    private String areaAddress;

    @ApiModelProperty("设备ID")
    private Long deviceId;

    @ApiModelProperty("机房ID")
    private Long roomId;
    @ApiModelProperty("所在机房")
    private String roomName;

    private Integer licenseStatus;
    @ApiModelProperty("许可情况")
    private String licenseStatusStr;

    @ApiModelProperty("设备检测情况（最近一次检测时间）")
    private Date deviceCheckDate;

    @ApiModelProperty("机房检测情况（最近一次检测时间）")
    private Date roomCheckDate;

    @ApiModelProperty("异常点数占比")
    private Integer abnormalRate;

    public String getLicenseStatusStr() {
        return EdeviceLicenseStatusEnum.getNameByValue(licenseStatus);
    }
}
