package cn.smarthse.rho.modules.sys.model.m.param;

import cn.smarthse.core.framework.model.PageParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;

/**
 * 在线监测设备 参数对象
 *
 * @author wuxq
 * @since 2024-04-10
 */
@EqualsAndHashCode(callSuper = false)
@Data
public class OnlineMonitorDeviceParam extends PageParam {

    private static final long serialVersionUID = 1L;

    private Long id;

    private String areaName;    //行政区划名称

    private String type;    //设备类型(化学、粉尘、噪声等等)

    private Byte status;    //设备状态

    private String keyword;  //关键字

    private String date;   //智能预警列表前端日期参数

    private String time;   //智能预警列表前端时间参数

    private Date dateBegin;  //时间范围开始

    private Date dateEnd;  //时间范围结束

    private String ids;     //导出ID组

    private Byte deviceType;    //设备类型（1-监测、2-监控、3-报警）

    private Byte[] types;  //多选预警类型

    private String creditCode;

    /**
     * flag==0    即status!=2 and status!=3  未整改
     * flag==2    即status==2                待验收
     * flag==3    即status==3                验收完成
     * flag==4    即status!=3                未整改、待验收
     * flag==5    即status!=2                未整改、验收完成
     * flag==6    即status in(2,3)           待验收、验收完成
     * flag==7    即status 没这个条件          未整改、待验收、验收完成
     */
    private Byte flag;  //多选设备状态

}
