package cn.smarthse.rho.modules.sys.model.g.vo;

import cn.smarthse.rho.modules.sys.enums.company.SafrtyDeviceStatusEnum;
import lombok.Data;
import lombok.experimental.Accessors;
import org.apache.commons.collections4.Get;
import org.apache.poi.util.StringUtil;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * 安全装置与警示标识自检审核记录视图对象
 * @Author: czq
 * @Creat: 2025-05-06 13:57
 */
@Data
@Accessors(chain = true)
public class GSafetyDeviceSelfCheckStatusLogListVo implements Serializable {
    private static final long serialVersionUID = 1L;

    /**
     * 审核状态str
     */
    private String statusStr;

    /**
     * 修改后字段值（审核状态）
     */
    private String afterValue;

    /**
     * 数据更新时间
     */
    private LocalDateTime editTime;


    public String getStatusStr() {
        if (StringUtil.isBlank(afterValue)){
            return null;
        }
        return SafrtyDeviceStatusEnum.getNameByValue(Integer.parseInt(afterValue));
    }
}
