package cn.smarthse.rho.modules.sys.model.g.vo;

import cn.smarthse.rho.modules.sys.model.sys.vo.SysFileVo;
import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.time.LocalDate;

/**
 * 安全装置自检列表的值对象
 */
@Data
@Accessors(chain = true)
public class GSafetyDeviceSelfCheckListVo implements Serializable {
    private static final long serialVersionUID = 1L;

    /**
     * 自检记录的唯一标识
     */
    private Long id;

    /**
     * 自检时间
     */
    private LocalDate checkTime;

    /**
     * 审核状态 如：0：草稿、1：待审核、2：被退回、3：已审核等
     */
    private Integer status;

    /**
     * 佐证材料的文件ID
     */
    private Long certificateFile;

    /**
     * 佐证材料的文件信息
     */
    private SysFileVo fileVo;
}
