package cn.smarthse.rho.modules.sys.model.g.param;

import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * 关键因素画像： 新增或编辑自检承诺参数
 * @author czq
 * @date 2025-05-06 13:41
 */
@EqualsAndHashCode(callSuper = false)
@Data
public class GSelfCheckCommitmentEditParam {

    /**
     * 医院ID（后端自动注入）
     */
    private Long cid;

    /**
     * 承诺人姓名，不能为空
     */
    @NotBlank(message = "承诺人姓名不能为空")
    private String name;

    /**
     * 承诺人电话，不能为空
     */
    @NotBlank(message = "承诺人电话不能为空")
    private String phone;

    /**
     * 承诺书文件ID，不能为空
     */
    @NotNull(message = "承诺书id不能为空")
    private Long commitmentFile;

    /**
     * 关键因素画像类型KeyFactorTypeEnum
     */
    private Integer keyFactorType;

}
