package cn.smarthse.rho.modules.sys.model.g.param;

import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotNull;
import java.time.LocalDate;

/**
 * 个人防护用品 新增或编辑自检信息参数
 * @author czq
 * @date 2025-05-06 13:41
 */
@EqualsAndHashCode(callSuper = false)
@Data
public class GEquipmentSelfCheckEditParam {

    /**
     * 自检ID（用于编辑场景）
     */
    private Long id;

    /**
     * 医院ID（后端自动注入）
     */
    private Long cid;

    /**
     * 自检时间
     */
    @NotNull(message = "自检时间不能为空")
    private LocalDate checkTime;

    /**
     * 佐证材料文件ID
     */
    @NotNull(message = "佐证材料不能为空")
    private Long certificateFile;

}
