package cn.smarthse.rho.modules.sys.model.f.vo;

import cn.smarthse.rho.modules.sys.entity.f.FProject;
import cn.smarthse.rho.modules.sys.enums.f.FProjectDetailStatusEnum;
import cn.smarthse.rho.modules.sys.enums.f.FProjectRaTypeEnum;
import cn.smarthse.rho.modules.sys.enums.f.FProjectStatusEnum;
import cn.smarthse.rho.modules.sys.enums.f.FProjectTypeEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;


/**
 * 三同时管理列表
 *
 * @author wuxq
 * @since 2024/4/10 16:20
 */
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "三同时管理列表", description = "医院：三同时管理列表VO")
@Data
public class FThreeTimesProjectVo extends FProject {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "三同时项目状态")
    private String statusStr;

    @ApiModelProperty(value = "三同时项目性质")
    private String projectTypeStr;

    @ApiModelProperty(value = "三同时项目类型")
    private String raTypeStr;

    @ApiModelProperty(value = "设备 预、控评id")
    private Long detail1Id;
    @ApiModelProperty(value = "设备 预、控评状态（1-进行中；2-已完成；）")
    private Integer detail1Status;
    @ApiModelProperty(value = "设备 预、控评状态中文")
    private String detail1StatusStr;
    @ApiModelProperty(value = "设备 预、控评服务机构名称")
    private String tech1Name;

    @ApiModelProperty(value = "场所 预、控评id")
    private Long detail2Id;
    @ApiModelProperty(value = "场所 预、控评状态（1-进行中；2-已完成；3-合理缺项）")
    private Integer detail2Status;
    @ApiModelProperty(value = "场所 预、控评状态中文")
    private String detail2StatusStr;
    @ApiModelProperty(value = "场所 预、控评服务机构名称")
    private String tech2Name;

    public String getStatusStr() {
        return FProjectStatusEnum.getNameByValue(this.getStatus());
    }

    public String getProjectTypeStr() {
        return FProjectTypeEnum.getNameByValue(this.getProjectType());
    }

    public String getRaTypeStr() {
        return FProjectRaTypeEnum.getNameByValue(this.getRaType());
    }

    public String getDetail1StatusStr() {
        return FProjectDetailStatusEnum.getNameByValue(detail1Status);
    }

    public String getDetail2StatusStr() {
        return FProjectDetailStatusEnum.getNameByValue(detail2Status);
    }
}
