package cn.smarthse.rho.modules.sys.model.f.param;

import cn.smarthse.core.framework.model.PageParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 三同时项目 参数对象
 *
 * @author wuxq
 * @since 2024-04-10
 */
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@Data
public class ThreeProjectQueryParam extends PageParam {

    @ApiModelProperty("项目状态（0-草稿；1-待审核；2-已完成；3-被退回）")
    private Integer status;

    @ApiModelProperty("项目性质（1-设备；2-场所；）")
    private Integer type;

    @ApiModelProperty("项目类型（1-X射线影像诊断；2-介入放射学；3-核医学；4-放射治疗）")
    private Integer raType;

    @ApiModelProperty("项目性质（1-新建；2-扩建；3-改建；4-技术引进；5-技术改造）")
    private Integer projectType;

    @ApiModelProperty("三同时项目id")
    private Long projectId;

    @ApiModelProperty("预评价或控制效果评价id")
    private Long detailId;

}
