
package cn.smarthse.rho.modules.sys.model.easyexcel.device;

import cn.smarthse.common.util.easyExcel.BaseImportDto;
import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.format.DateTimeFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;


/**
 * 密封放射源 导入对象
 */
@Data
public class SourceSealedImportDto extends BaseImportDto implements Serializable{
	private static final long serialVersionUID = -1308959520914804310L;

	@ApiModelProperty(value = "excel行号")
	@ExcelIgnore
	private Integer excelRowIndex;

	@ApiModelProperty(value = "excel行号+1")
	@ExcelIgnore
	private Integer realityExcelRowIndex;



	@ExcelProperty(value = "核素名称")
	private String name;

	@ExcelProperty(value = "核素生产厂家")
	private String factory;

	/**
	 * 状态（1-正常；2-暂停使用；3-退役报废）
	 */
	@ExcelProperty(value = "放射源状态")
	private String statusStr;
	@ExcelIgnore
	private Integer status;

	@ExcelProperty(value = "用途")
	private String useTo;

	@ExcelProperty(value = "编号")
	private String factoryNo;


	// ***********************

	@ExcelProperty(value = "国家编码")
	private String nuclideUniqueCode;

	@ExcelProperty(value = "出厂活度")
	private String factoryActivity;
	/**
	 * 出厂活度（前，保留两位小数）
	 */
	@ExcelIgnore
	private BigDecimal data1;
	/**
	 * 出厂活度（后）
	 */
	@ExcelIgnore
	private Integer data2;


	@ExcelProperty(value = "活度测量日期")
	// @DateTimeFormat("yyyy-MM-dd")
	private String measurementDate;

	@ExcelProperty(value = "出厂日期")
	// @DateTimeFormat("yyyy-MM-dd")
	private String productionDate;

	@ExcelProperty(value = "负责人")
	private String personInCharge;



	public Integer getStatus() {
		if (statusStr == null){
			return null;
		}
		if (statusStr.equals("正常")){
			status = 1;
		} else if (statusStr.equals("暂停使用")){
			status = 2;
		} else if (statusStr.equals("退役报废")){
			status = 3;
		}
		return status;
	}


	public BigDecimal getData1() {
		if (factoryActivity == null){
			return null;
		}
		// 解析factoryActivity，×10^前的字符转为data1
		data1 = new BigDecimal(factoryActivity.substring(0, factoryActivity.indexOf("×10^")));
		return data1;
	}

	public Integer getData2() {
		if (factoryActivity == null){
			return null;
		}
		// 解析factoryActivity，×10^后的字符转为data2
		data2 = Integer.parseInt(factoryActivity.substring(factoryActivity.indexOf("×10^") + 4));
		return data2;
	}



}
