
package cn.smarthse.rho.modules.sys.model.easyexcel.device;

import cn.smarthse.common.util.easyExcel.BaseImportDto;
import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.format.DateTimeFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 机房 导入对象
 */
@Data
public class MachineRoomImportDto extends BaseImportDto implements Serializable{
	private static final long serialVersionUID = -1311432086012545037L;

	@ApiModelProperty(value = "excel行号")
	@ExcelIgnore
	private Integer excelRowIndex;

	@ApiModelProperty(value = "excel行号+1")
	@ExcelIgnore
	private Integer realityExcelRowIndex;



	@ExcelProperty(value = "机房名称")
	private String name;

	@ExcelProperty(value = "所在附属对象")
	private String companyName;
	@ExcelIgnore
	private Long cid;

	@ExcelProperty(value = "是否为车载机房")
	private String isOnboardStr;
	/**
	 * 是否为车载机房（0-否；1-是）
	 */
	@ExcelIgnore
	private Integer isOnboard;



	@ExcelProperty(value = "场所等级")
	private String levelStr;
	/**
	 * 工作场所级别(1-甲级；2-乙级；3-丙级)
	 */
	@ExcelIgnore
	private Integer level;

	public Integer getIsOnboard() {
		if (isOnboardStr == null){
			return null;
		}
		if(isOnboardStr.equals("是")){
			isOnboard=1;
		}else{
			isOnboard=0;
		}
		return isOnboard;
	}

	public Integer getLevel() {
		if (levelStr == null){
			return null;
		}
		if (levelStr.equals("甲级")){
			level=1;
		}else if (levelStr.equals("乙级")){
			level=2;
		}else if (levelStr.equals("丙级")){
			level=3;
		}
		return level;
	}
}
