
package cn.smarthse.rho.modules.sys.model.easyexcel.device;

import cn.smarthse.common.util.easyExcel.BaseImportDto;
import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.format.DateTimeFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 含密封源装置 导入对象
 */
@Data
public class DeviceSourceImportDto extends BaseImportDto implements Serializable{
	private static final long serialVersionUID = -435845430487754849L;

	@ApiModelProperty(value = "excel行号")
	@ExcelIgnore
	private Integer excelRowIndex;

	@ApiModelProperty(value = "excel行号+1")
	@ExcelIgnore
	private Integer realityExcelRowIndex;



	@ExcelProperty(value = "装置名称")
	private String name;

	@ExcelProperty(value = "设备编号")
	private String factoryNo;

	@ExcelProperty(value = "生产厂家")
	private String factory;

	/**
	 * 状态（1-正常；2-暂停使用；3-退役报废）
	 */
	@ExcelProperty(value = "设备状态")
	private String statusStr;
	@ExcelIgnore
	private Integer status;


	// ***********************

	@ExcelProperty(value = "型号")
	private String model;

	// @ExcelProperty(value = "放射诊疗类别")
	// private String diagnosisTypeStr;
	// @ExcelIgnore
	// private String diagnosisType;

	@ExcelProperty(value = "负责人")
	private String personInCharge;


	public Integer getStatus() {
		if (statusStr == null){
			return null;
		}
		if (statusStr.equals("正常")){
			status = 1;
		} else if (statusStr.equals("暂停使用")){
			status = 2;
		} else if (statusStr.equals("退役报废")){
			status = 3;
		}
		return status;
	}


}
