
package cn.smarthse.rho.modules.sys.model.easyexcel;

import cn.smarthse.common.util.easyExcel.BaseImportDto;
import com.alibaba.excel.annotation.ExcelProperty;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;


@Data
public class StaffImportDtoV2 extends BaseImportDto implements Serializable{
	private static final long serialVersionUID = 6228683044372553157L;

	@ApiModelProperty(value = "excel行号")
	private Integer excelRowIndex;


	@ApiModelProperty(value = "excel行号+1")
	private Integer realityExcelRowIndex;

	@ApiModelProperty(value = "姓名")
	@ExcelProperty("姓名")
	private String name;

	@ApiModelProperty(value = "手机号")
	@ExcelProperty("手机号码")
	private String phone;

	@ApiModelProperty(value = "身份证")
	@ExcelProperty("身份证号")
	private String idcard;

	@ApiModelProperty(value = "性别")
	@ExcelProperty("性别")
	private String sex;

	@ApiModelProperty(value = "年龄")
	@ExcelProperty("年龄")
	private String age;

	@ApiModelProperty(value = "职业照射种类及代码")
	@ExcelProperty("职业照射种类及代码")
	private String raType;



	@ApiModelProperty(value = "院区")
	@ExcelProperty("所在院区")
	private String companyName;

	@ExcelProperty("部门/科室")
	private String orgName;

	@ExcelProperty("岗位/工种")
	private String postName;

	@ExcelProperty("本岗位上岗时间")
	private String postStartTime;

	@ApiModelProperty(value = "工号")
	@ExcelProperty("工号")
	private String workNo;

	public Integer getRealityExcelRowIndex() {
		return this.excelRowIndex == null ? null : excelRowIndex + 1;
	}

}
