
package cn.smarthse.rho.modules.sys.model.easyexcel;

import cn.smarthse.common.util.easyExcel.BaseImportDto;
import com.alibaba.excel.annotation.ExcelProperty;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;


@Data
public class StaffImportDto extends BaseImportDto implements Serializable{
	private static final long serialVersionUID = 7724801396893204882L;

	@ApiModelProperty(value = "excel行号")
	private Integer excelRowIndex;


	@ApiModelProperty(value = "excel行号+1")
	private Integer realityExcelRowIndex;

	@ApiModelProperty(value = "姓名")
	@ExcelProperty("姓名")
	private String name;

	@ApiModelProperty(value = "手机号")
	@ExcelProperty("手机号码")
	private String phone;

	@ApiModelProperty(value = "身份证")
	@ExcelProperty("身份证号")
	private String idcard;

	@ApiModelProperty(value = "性别")
	@ExcelProperty("性别")
	private String sex;

	@ApiModelProperty(value = "年龄")
	@ExcelProperty("年龄")
	private String age;

	@ApiModelProperty(value = "职业照射种类及代码")
	@ExcelProperty("职业照射种类及代码")
	private String raType;



	//下面是公司相关数据
	@ApiModelProperty(value = "院区")
	@ExcelProperty("所在院区")
	private String companyName;

	@ApiModelProperty(value = "工号")
	@ExcelProperty("工号")
	private String workNo;

	public Integer getRealityExcelRowIndex() {
		return this.excelRowIndex == null ? null : excelRowIndex + 1;
	}

}
