
package cn.smarthse.rho.modules.sys.model.easyexcel;

import cn.smarthse.common.util.easyExcel.BaseImportDto;
import com.alibaba.excel.annotation.ExcelProperty;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;


@Data
public class StaffImportAdminDto extends BaseImportDto implements Serializable{
	private static final long serialVersionUID = 7724801396893204882L;

	@ApiModelProperty(value = "excel行号")
	private Integer excelRowIndex;


	@ApiModelProperty(value = "excel行号+1")
	private Integer realityExcelRowIndex;

	@ApiModelProperty(value = "数据源id")
	@ExcelProperty("sourceId")
	private String sourceId;

	@ApiModelProperty(value = "姓名")
	@ExcelProperty("name")
	private String name;

	@ApiModelProperty(value = "手机号")
	@ExcelProperty("phone")
	private String phone;

	@ApiModelProperty(value = "身份证")
	@ExcelProperty("idcard")
	private String idcard;


	@ApiModelProperty(value = "职业照射种类及代码")
	@ExcelProperty("raType")
	private String raType;



	@ApiModelProperty(value = "院区")
	@ExcelProperty("companyName")
	private String companyName;

	public Integer getRealityExcelRowIndex() {
		return this.excelRowIndex == null ? null : excelRowIndex + 1;
	}

}
