
package cn.smarthse.rho.modules.sys.model.easyexcel;

import cn.smarthse.common.util.easyExcel.BaseImportDto;
import com.alibaba.excel.annotation.ExcelProperty;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;


@Data
public class CompanyImportDto extends BaseImportDto implements Serializable{
	private static final long serialVersionUID = 7724801396893204882L;

	@ApiModelProperty(value = "excel行号")
	private Integer excelRowIndex;


	@ApiModelProperty(value = "excel行号+1")
	private Integer realityExcelRowIndex;

	@ApiModelProperty(value = "万达编码")
	@ExcelProperty("万达编码")
	private String wandaSourceId;

	@ApiModelProperty(value = "医院名称")
	@ExcelProperty("放射诊疗机构名称")
	private String hospitalName;

	@ApiModelProperty(value = "统一社会信用代码")
	@ExcelProperty("统一社会信用代码")
	private String creditCode;

	@ApiModelProperty(value = "院区名称")
	@ExcelProperty("附属对象（院区）名称")
	private String name;

	@ApiModelProperty(value = "全国唯一标识码")
	@ExcelProperty("全国唯一标识码")
	private String medicalNucode;

	@ApiModelProperty(value = "行政区划")
	@ExcelProperty("行政区划")
	private String area;

	@ApiModelProperty(value = "行政区划")
	@ExcelProperty("注册地址")
	private String registerArea;

	@ApiModelProperty(value = "是否市本级管理")
	@ExcelProperty("是否市本级管理")
	private String isBelongCityLevel;

	@ApiModelProperty(value = "法定代表人")
	@ExcelProperty("法定代表人")
	private String legalName;

	@ApiModelProperty(value = "是否作为试运行放射诊疗机构")
	@ExcelProperty("是否作为试运行放射诊疗机构")
	private String isTestRun;

	public Integer getRealityExcelRowIndex() {
		return this.excelRowIndex == null ? null : excelRowIndex + 1;
	}

}
