package cn.smarthse.rho.modules.sys.model.e.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;


@Data
public class ESourceNonSealedVo implements Serializable{
	private static final long serialVersionUID = -262331019709988620L;
	
	private Long id;

	private Long did;
	
	
	/**
	 * 物理状态（1-固态；2-液态；3-气态）
	 */
	@ApiModelProperty(value = "物理状态（1-固态；2-液态；3-气态）")
	private Integer physicalState;
	
	/**
	 * 最大等效日操作量(底数，，保留两位小数)
	 */
	@ApiModelProperty(value = "最大等效日操作量(底数，，保留两位小数)")
	private BigDecimal data1;
	
	/**
	 * 最大等效日操作量(指数)
	 */
	@ApiModelProperty(value = "最大等效日操作量(指数)")
	private Integer data2;
	
	/**
	 * 最大等效年操作量(底数，，保留两位小数)
	 */
	@ApiModelProperty(value = "最大等效年操作量(底数，，保留两位小数)")
	private BigDecimal data3;
	
	/**
	 * 最大等效年操作量(指数)
	 */
	@ApiModelProperty(value = "最大等效年操作量(指数)")
	private Integer data4;

	/**
	 * 出厂活度(底数，保留两位小数)
	 */
	@ApiModelProperty(value = "出厂活度(底数，保留两位小数)")
	private BigDecimal data5;

	/**
	 * 出厂活度(指数)
	 */
	@ApiModelProperty(value = "出厂活度(指数)")
	private Integer data6;
	
	/**
	 * 负责人
	 */
	@ApiModelProperty(value = "负责人")
	private String personInCharge;

	/**
	 * 核素当前对应的设备
	 */
	@ApiModelProperty(value = "核素当前对应的设备")
	private List<EDeviceCurBindDeviceVo> curDeviceList;

}
