package cn.smarthse.rho.modules.sys.model.e.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;


/**
 * 核素对应的设备 信息
 *
 * @author chuhy
 * @date 2024/5/31 14:10
 */
@Data
public class ESourceBindDeviceVo implements Serializable{
	private static final long serialVersionUID = -3487365289742025827L;

	@ApiModelProperty("核素与机房下设备的关联id")
	private Long id;

	@ApiModelProperty("装置id")
	private Long deviceId;

	@ApiModelProperty("装置名称")
	private String deviceName;

	@ApiModelProperty(value = "类型（1-射线装置；2-非密封放射性核素；3-密封放射源；4-含密封源装置）")
	private Integer type;

	@ApiModelProperty("型号")
	private String model;

	@ApiModelProperty(value = "编号")
	private String factoryNo;

	@ApiModelProperty(value = "生产厂家")
	private String factory;

	@ApiModelProperty(value = "三同时项目id（f_project.id）")
	private Long projectId;

}
