package cn.smarthse.rho.modules.sys.model.e.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;


@Data
public class EMachineRoomListVo implements Serializable{
	private static final long serialVersionUID = 7713543382031932900L;
	
	
	private Long id;

	
	/**
	 * 机房名称
	 */
	@ApiModelProperty(value = "机房名称")
	private String name;
	
	/**
	 * 院区名称
	 */
	@ApiModelProperty(value = "院区名称")
	private String companyName;

	/**
	 * 机房编号
	 */
	@ApiModelProperty(value = "机房编号")
	private String roomCode;


	/**
	 * 工作场所级别(1-甲级；2-乙级；3-丙级)
	 */
	@ApiModelProperty(value = "工作场所级别(1-甲级；2-乙级；3-丙级)")
	private Integer level;


	/**
	 * 射线装置(数量)
	 */
	@ApiModelProperty(value = "射线装置(数量)")
	private Integer rayDeviceNum;

	/**
	 * 非密封放射性核素(种类数)
	 */
	@ApiModelProperty(value = "非密封放射性核素(种类数)")
	private Integer nonSealedSpeciesNum;

	/**
	 * 放射诊疗类别(1-X射线影像诊断；2-介入放射学；3-核医学；4-放射治疗)
	 */
	@ApiModelProperty(value = "放射诊疗类别(1-X射线影像诊断；2-介入放射学；3-核医学；4-放射治疗)")
	private String diagnosisType;

	/**
	 * 许可证状态(0-无；1-未许可；2-已许可)
	 */
	@ApiModelProperty(value = "许可证状态(0-无；1-未许可；2-已许可)")
	private Integer licenseStatus;

	/**
	 * 已许可状态类型(0-无；1-正常；2-校验即将到期；3-校验已过期) (licenseStatus=2时才会有)
	 */
	@ApiModelProperty(value = "已许可状态类型(0-无；1-正常；2-校验即将到期；3-校验已过期) (licenseStatus=2时才会有)")
	private Integer licenseStatusType;

	/**
	 * 预警状态(0-无；21-首次预警；22-黄色预警；31-红色预警；32-启动执法)
	 */
	@ApiModelProperty(value = "预警状态(0-无；21-首次预警；22-黄色预警；31-红色预警；32-启动执法)")
	private Integer warningStatus;


	/**
	 * 是否被关联(0-无；1-是)
	 */
	@ApiModelProperty(value = "是否被关联(0-无；1-是)")
	private Integer isRelated;


}
