package cn.smarthse.rho.modules.sys.model.e.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;


/**
 * 机房-场所检测记录
 * @author chuhy
 * @date 2024/9/3 14:33
 */
@Data
public class EMachineRoomCheckDataVo implements Serializable{
	private static final long serialVersionUID = -6580912406515053179L;


	private Long id;

	/**
	 * 检测机构名称
	 */
	@ApiModelProperty("检测机构名称")
	private String orgName;
	
	/**
	 * 检测类型（1-控评检测；2-年度检测；）
	 */
	@ApiModelProperty("检测类型（1-控评检测；2-年度检测；）")
	private Integer type;

	/**
	 * 检测时间
	 */
	@ApiModelProperty("检测时间")
	private Date checkTime;

	/**
	 * 报告编号
	 */
	@ApiModelProperty("报告编号")
	private String reportNo;

	/**
	 * 报告url
	 */
	@ApiModelProperty("报告url")
	private String reportUrl;

	/**
	 * 检测结果(0-不合格；1-合格；)
	 */
	@ApiModelProperty("检测结果(0-不合格；1-合格；)")
	private Integer checkResult;

	/**
	 * 更新时间
	 */
	@ApiModelProperty("更新时间")
	private Date updateDate;


}
