package cn.smarthse.rho.modules.sys.model.e.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 含密封源装置Vo
 */
@Data
public class EDeviceSourceVo implements Serializable{
	private static final long serialVersionUID = 2740196547531686105L;
	
	private Long id;
	
	private Long did;
	
	
	/**
	 * 型号
	 */
	@ApiModelProperty(value = "型号")
	private String model;
	
	/**
	 * 放射诊疗类别(1-X射线影像诊断；2-介入放射学；3-核医学；4-放射治疗)
	 */
	@ApiModelProperty(value = "放射诊疗类别(1-X射线影像诊断；2-介入放射学；3-核医学；4-放射治疗)")
	private String diagnosisType;
	
	/**
	 * 负责人
	 */
	@ApiModelProperty(value = "负责人")
	private String personInCharge;

	// *************来自装置所存放的核素
	/**
	 * 核素名称
	 */
	@ApiModelProperty(value = "核素名称")
	private String sourceName;

	/**
	 * 出厂活度（前，保留两位小数）
	 */
	@ApiModelProperty(value = "出厂活度（前，保留两位小数）")
	private BigDecimal data1;

	/**
	 * 出厂活度（后）
	 */
	@ApiModelProperty(value = "出厂活度（后）")
	private Integer data2;

	/**
	 * 活度测量日期
	 */
	@ApiModelProperty(value = "活度测量日期")
	private Date measurementDate;

	/**
	 * 核素生产厂家
	 */
	@ApiModelProperty(value = "核素生产厂家")
	private String sealFactory;
	// *************来自装置所存放的核素

}
