package cn.smarthse.rho.modules.sys.model.e.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDate;

/**
 * 设备档案 - 基础信息
 */
@Data
public class EDeviceProtectEqVo implements Serializable{
	private static final long serialVersionUID = 1220885590800351684L;
	@ApiModelProperty("设备id")
	private Long id;

	/**
	 * 名称
	 */
	@ApiModelProperty(value = "名称")
	private String name;
	
	/**
	 * 编号
	 */
	@ApiModelProperty(value = "编号")
	private String factoryNo;
	
	/**
	 * 生产厂家
	 */
	@ApiModelProperty(value = "生产厂家")
	private String factory;
	
	/**
	 * 状态（1-正常；2-暂停使用；3-退役/报废）
	 */
	@ApiModelProperty(value = "状态（1-正常；2-暂停使用；3-退役/报废）")
	private Integer status;
	
	/**
	 * 类型（1-射线装置；2-非密封放射性核素；3-密封放射源；4-含密封源装置）
	 */
	@ApiModelProperty(value = "类型（1-射线装置；2-非密封放射性核素；3-密封放射源；4-含密封源装置）")
	private Integer type;


	/**
	 * 许可证状态(1-未许可；2-已许可)
	 */
	@ApiModelProperty(value = "许可证状态(1-未许可；2-已许可)")
	private Integer licenseStatus;

	/**
	 * 已许可状态类型(1-正常；2-校验即将到期；3-校验已过期) (licenseStatus=2时才会有)
	 */
	@ApiModelProperty(value = "已许可状态类型(1-正常；2-校验即将到期；3-校验已过期) (licenseStatus=2时才会有)")
	private Integer licenseStatusType;
	/**
	 * 设备型号
	 */
	@ApiModelProperty(value = "设备型号")
	private String model;

	/**
	 * 最近一次检测时间
	 */
	@ApiModelProperty(value = "最近一次检测时间")
	private LocalDate testingDate;
	/**
	 * 最近一次检测结果
	 */
	@ApiModelProperty(value = "最近一次检测结果")
	private Integer testingResult;

	@ApiModelProperty(value = "设备预警状态(0-无；1-首次预警；2-黄色预警；3-红色预警；4-启动执法）")
	private Integer warningStatus;

}
