package cn.smarthse.rho.modules.sys.model.e.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;


/**
 * 设备性能检测记录
 *
 * @author chuhy
 * @date 2024/5/31 14:10
 */
@Data
public class EDevicePerformanceCheckVo implements Serializable{
	private static final long serialVersionUID = -9085669934773790932L;

	@ApiModelProperty("检测机构名称")
	private String checkOrgName;

	@ApiModelProperty("检测类型（1-状态检测；2-验收检测；3-稳定性检测；）")
	private Integer type;

	@ApiModelProperty("检测时间")
	private Date checkTime;

	@ApiModelProperty("报告编号")
	private String reportNo;



	@ApiModelProperty("设备名称")
	private String deviceName;

	@ApiModelProperty("设备型号")
	private String typeNo;

	@ApiModelProperty("出厂编号")
	private String factoryNo;

	@ApiModelProperty("所在院区")
	private String companyBranch;

	@ApiModelProperty("所在场所")
	private String location;

	@ApiModelProperty("检测结果：0-不合格；1-合格；")
	private Integer checkResult;
}
