package cn.smarthse.rho.modules.sys.model.e.vo;

import cn.smarthse.rho.modules.sys.model.e.param.ERelationDto;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;


/**
 * 设备档案 - 列表详情vo
 */
@Data
public class EDeviceListDetailVo implements Serializable{
	private static final long serialVersionUID = -4927611491232924370L;
	

	/**
	 * 基础信息
	 */
	@ApiModelProperty(value = "基础信息")
	private EDeviceBaseVo deviceBaseVo;
	
	/**
	 * 射线装置详情
	 */
	@ApiModelProperty(value = "射线装置详情")
	private EDeviceRayVo deviceRayVo;

	/**
	 * 含密封源装置详情
	 */
	@ApiModelProperty(value = "含密封源装置详情")
	private EDeviceSourceVo deviceSourceVo;

	/**
	 * 非密封放射源详情
	 */
	@ApiModelProperty(value = "非密封放射源详情")
	private ESourceNonSealedVo sourceNonSealedVo;

	/**
	 * 密封放射源详情
	 */
	@ApiModelProperty(value = "密封放射源详情")
	private ESourceSealedVo sourceSealedVo;

	/**
	 * 核素-机房-设备关系list
	 */
	@ApiModelProperty(value = "核素-机房-设备关系list")
	private List<ERelationDto> relationDtoList;

	/**
	 * 装置当前绑定的核素列表
	 */
	@ApiModelProperty(value = "装置当前绑定的核素列表")
	private List<EDeviceHistorySourceVo> deviceBindSourceList;


	@ApiModelProperty(value = "距离当前时间最近一次检测时间")
	private Date lastCheckDate;

	@ApiModelProperty(value = "最近一次检测结果")
	private Integer lastCheckResult;
}
