package cn.smarthse.rho.modules.sys.model.e.param;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;


/**
 * 设备档案 - 射线装置 - 详情信息
 */
@Data
public class EDeviceRayDto implements Serializable{
	private static final long serialVersionUID = -25325892996401421L;
	
	private Long id;

	private Long did;

	/**
	 * 设备移动类型(1-固定设备；2-移动设备；3-车载设备)
	 */
	@ApiModelProperty(value = "设备移动类型(1-固定设备；2-移动设备；3-车载设备)")
	private Integer mobilityType;

	/**
	 * 是否为床边机(0-否；1-是)（mobility_type为2时才有值）
	 */
	@ApiModelProperty(value = "是否为床边机(0-否；1-是)（mobility_type为2时才有值）")
	private Integer isBedside;

	/**
	 * 放射诊疗类别(英文逗号分隔)(EdeviceDiagnosisTypeEnum)
	 */
	@ApiModelProperty(value = "放射诊疗类别(英文逗号分隔)(EdeviceDiagnosisTypeEnum)")
	private String diagnosisType;

	/**
	 * 型号
	 */
	@ApiModelProperty(value = "型号")
	private String model;

	/**
	 * 主要参数
	 */
	@ApiModelProperty(value = "主要参数")
	private String parameters;

	/**
	 * 球管个数
	 */
	@ApiModelProperty(value = "球管个数")
	private Integer bulbNum;

	/**
	 * 放射检查类型（EdeviceRayCheckTypeEnum）
	 */
	@ApiModelProperty(value = "放射检查类型（EdeviceRayCheckTypeEnum）")
	private Integer checkType;

	/**
	 * 出厂日期
	 */
	@ApiModelProperty(value = "出厂日期")
	private Date productionDate;

	/**
	 * 安装单位
	 */
	@ApiModelProperty(value = "安装单位")
	private String installationUnit;

	/**
	 * 负责人
	 */
	@ApiModelProperty(value = "负责人")
	private String personInCharge;

}
