package cn.smarthse.rho.modules.sys.model.c.vo;

import cn.smarthse.common.sensitive.annotation.Desensitization;
import cn.smarthse.common.sensitive.enumd.DesensitizationType;
import cn.smarthse.core.framework.model.BaseEntity;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.time.LocalDate;

@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class StaffSelectInfo extends BaseEntity implements Serializable {

    private static final long serialVersionUID = 1L;
    
    private Long id;

    @ApiModelProperty(value = "姓名")
    private String name;

    @ApiModelProperty(value = "手机号")
    @Desensitization(type = DesensitizationType.MOBILE_PHONE)
    private String phone;

    @ApiModelProperty(value = "身份证类型")
    private String idcardType;

    @ApiModelProperty(value = "身份证")
    @Desensitization(type = DesensitizationType.ID_CARD)
    private String idcard;

    @ApiModelProperty(value = "性别 0-女；1-男")
    private Integer sex;

    @ApiModelProperty(value = "年龄")
    private Integer age;

    @ApiModelProperty(value = "出生日期")
    private LocalDate birthday;
}
